---
title: Lecture 18：高阶导数
tags:
  - 数学
categories: 
date: 2023-12-18
---
---
## 1.1 多阶导数的定义
**多阶导数的表示方法**
$(y^{\prime})^{\prime}=y^2=\frac{d^2y}{dx^2}\quad\quad y^{m}\quad\quad y^{(4)}\quad\quad y^{(n)}=\frac{d^ny}{dx^n}$

##### **定义**： #高阶导数
> <font color="#ccc1d9">描述：</font> 具体点上，n 阶导数的定义：
> 定义 1：$f^{(n)}(x_0)=\lim_{\Delta x\to0}\frac{f^{(n-1)}(x_0+\Delta x)-f^{(n-1)}(x_0)}{\Delta x}$
> 定义 2：$f^{(n)}(x_0)=\lim_{x\to x_0}\frac{f^{(n-1)}(x)-f^{(n-1)}(x_0)}{x-x_0}$

**解释**
+ 结论：
	+ 如果函数 $f(x)$ 在点 x 处 n 阶可导，则在点 x 的某邻域内 $f(x)$ 必定**具有一切低于 n 阶的导数**；
+ 概念：
	+ 若 $f^{(n)}(x)$ 在区间 $I$ 上连续，称 $f(x)$ 在 $I$ 上 n 阶连续可导
	+  n 阶导函数存在，而且还是连续的；

## 1.2 常见求 n 阶导数
### 1.2.1 常见结论
**常见求 n 阶导数**
+ 指数
	+ $(e^{x})^{(n)}=e^{x}$
+ 三角函数
	+ $(\sin x)^{(n)}=\sin(x+n\frac\pi2)$
	+ $(\cos x)^{(n)}=\cos(x+n\frac{\pi}{2})$
+ In 函数
	+ $(\ln(1+x))^{(n)}=(-1)^{n-1}\frac{(n-1)!}{(1+x)^n}$
+ 加法
	+ $(u\pm v)^{(n)}=u^{(n)}\pm v^{(n)}$
+ 乘法
	+ 莱布尼茨公式
	+ ${(u\nu)^{(n)}}=\sum_{k=0}^nC_n^ku^{(k)}v^{(n-k)}$

**例题**：$\text{设 }f(x)=\frac1{x^2-1}\text{,求 }f^{(n)}(x)$
思路：无法直接使用加法或者乘法公式，因此需要将分母分解因式，将其拆分：
+ $\begin{aligned}f(x)&=\frac{1}{(x-1)(x+1)}=\frac{1}{2}\frac{(x+1)-(x-1)}{(x-1)(x+1)}\\&=\frac{1}{2}\left[\frac{1}{x-1}-\frac{1}{x+1}\right]\end{aligned}$
拆分完成后，使用加法的 n 阶导数：
+ $f^{(n)}(x)=\frac12\left[(\frac1{x-1})^{(n)}-(\frac1{x+1})^{(n)}\right]$
+ 然后先分析一个：$(\frac1{x-1})^{(n)}=(-1)^nn!(x-1)^{-(n+1)}$
+ $f^{(n)}(x)=\frac{1}{2}\left[\frac{(-1)^{n}n!}{(x-1)^{n+1}}-\frac{(-1)^{n}n!}{(x+1)^{n+1}}\right].$

### 1.2.2 复合函数高阶求导
**举例**：比如求 $y=sin3x$ 的导数；
+ 这其中的 sinx 有对应的高阶导数求导公式，但其中复合了 3 x；
+ 此时可以将 u=3 x，然后利用复合函数求导法则，提出其中 u 导致的复合的部分，然后带入原本的高阶导数求导公式；

## 1.3 常考题型
### 题型： #高阶导数求导
#### PART 1：解题方法
**基本思路**
+ 1. 有公式时，带入公式；
	+ 求 n 阶导函数 $f^{(n)}(x)$
+ 2. 没有公式时，带入一阶、二阶导数，找一般规律；
	+ 求 n 阶导函数 $f^{(n)}(x)$
+ 3. 使用泰勒公式展开
	+ 求具体点：$f^{(n)}(x_0)$ 在这一点展开泰勒

#### PART 2：典型例题
**例题**：$\text{设函数}\quad y=\frac1{2x+3},\quad\text{则 }y^{(n)}(0)=$？
+ 分析
+ 解析
	+ 方法一：找规律 
		+ $\begin{aligned}&y^{\prime}=(-1)(2 x+3)^{-2}\cdot 2 \\&y^{\prime\prime}=(-1)(-2)(2 x+3)^{-3}\cdot 2^{2} \\&y^{(n)}=(-1)^{n}n! (2 x+3)^{-(n+1)}. 2^{n}\end{aligned}$
		+ 然后带入 0 点到 n 阶的导数；
	+ 方法二：用泰勒 
		+ $f(x)=f(0)+f^{\prime}(0)x+\frac{f^{\prime\prime}(0)}{2!}x^2+\cdots$
+ 题型： #高阶导数求导 
